/**************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Installer Framework.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
**************************************************************************/
#include "packagemanagerlicenceagreementpage.h"
#include "packagemanagergui.h"

#include "component.h"
#include "componentmodel.h"
#include "errors.h"
#include "fileutils.h"
#include "messageboxhandler.h"
#include "packagemanagercore.h"
#include "progresscoordinator.h"
#include "performinstallationform.h"
#include "settings.h"
#include "utils.h"
#include "scriptengine.h"
#include "productkeycheck.h"

#include "kdsysinfo.h"

#include <QApplication>

#include <QString>
#include <QSettings>
#include <QtCore/QDir>
#include <QtCore/QPair>
#include <QtCore/QProcess>
#include <QtCore/QTimer>
#include <QTranslator>
#include <QDir>
#include <QDirIterator>
#include <QTextCodec>
#include <QFileInfo>
#include <QStringList>
#include <QScopedPointer>

#include <QCheckBox>
#include <QDesktopServices>
#include <QFileDialog>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QHeaderView>
#include <QLabel>
#include <QLineEdit>
#include <QListWidget>
#include <QListWidgetItem>
#include <QMessageBox>
#include <QProgressBar>
#include <QPushButton>
#include <QRadioButton>
#include <QTextBrowser>
#include <QTreeView>
#include <QVBoxLayout>
#include <QShowEvent>
#include <QComboBox>

#ifdef Q_OS_WIN
# include <qt_windows.h>
# include <QWinTaskbarButton>
# include <QWinTaskbarProgress>
#endif

using namespace KDUpdater;
using namespace QInstaller;

// -- LicenseAgreementPage

/*!
    \class QInstaller::LicenseAgreementPage
    \inmodule QtInstallerFramework
    \brief The LicenseAgreementPage presents a license agreement to the end
    users for acceptance.

    The license check page is displayed if you specify a license file in the
    package information file and copy the file to the meta directory. End users must
    accept the terms of the license agreement for the installation to continue.
*/

/*!
    Constructs a license check page with \a core as parent.
*/
LicenseAgreementPage::LicenseAgreementPage(PackageManagerCore *core)
    : PackageManagerPage(core)
{
    setObjectName(QLatin1String("LicenseAgreementPage"));

    QVBoxLayout *layout = new QVBoxLayout(this);
    setLayout(layout);

    m_msgLabel = new QLabel;
    m_msgLabel->setWordWrap(true);
    m_msgLabel->setObjectName(QLatin1String("MessageLabel"));

    m_agreeLabel = new QLabel;
    m_agreeLabel->setWordWrap(true);
    m_agreeLabel->setObjectName(QLatin1String("AgreeLabel"));
    auto font = m_agreeLabel->font();
    font.setBold(true);
    m_agreeLabel->setFont(font);

    QGridLayout *agreeLayout = new QGridLayout();
    agreeLayout->setVerticalSpacing(10);

    m_eulaCheckBox = new QCheckBox();
    m_eulaCheckBox->setFocusPolicy(Qt::FocusPolicy::NoFocus);
    connect(m_eulaCheckBox, &QCheckBox::clicked, this, &LicenseAgreementPage::forceUpdateEnabled);

    m_eulaLabel = new QLabel();
    m_eulaLabel->setOpenExternalLinks(true);
    m_eulaLabel->setWordWrap(true);

    agreeLayout->addWidget(m_eulaCheckBox, 0, 0);
    agreeLayout->addWidget(m_eulaLabel,0, 1);

    m_termsAndConditionsCheckBox = new QCheckBox();
    m_termsAndConditionsCheckBox->setFocusPolicy(Qt::FocusPolicy::NoFocus);
    connect(m_termsAndConditionsCheckBox, &QCheckBox::clicked, this, &LicenseAgreementPage::forceUpdateEnabled);

    m_termsAndConditionsLabel = new QLabel();
    m_termsAndConditionsLabel->setOpenExternalLinks(true);
    m_termsAndConditionsLabel->setWordWrap(true);    

    agreeLayout->addWidget(m_termsAndConditionsCheckBox, 1, 0);
    agreeLayout->addWidget(m_termsAndConditionsLabel, 1, 1);

    m_privacyStatementCheckBox = new QCheckBox();
    m_privacyStatementCheckBox->setFocusPolicy(Qt::FocusPolicy::NoFocus);
    connect(m_privacyStatementCheckBox, &QCheckBox::clicked, this, &LicenseAgreementPage::forceUpdateEnabled);

    m_privacyStatementLabel = new QLabel();
    m_privacyStatementLabel->setOpenExternalLinks(true);
    m_privacyStatementLabel->setWordWrap(true);

    agreeLayout->addWidget(m_privacyStatementCheckBox, 2, 0);
    agreeLayout->addWidget(m_privacyStatementLabel, 2, 1);
    agreeLayout->addItem(new QSpacerItem(10, 10, QSizePolicy::Expanding, QSizePolicy::Fixed), 3, 1, 1, 1);

    layout->addWidget(m_msgLabel);
    layout->addItem(new QSpacerItem(10, 10, QSizePolicy::Fixed, QSizePolicy::Fixed));
    layout->addWidget(m_agreeLabel);
    layout->addLayout(agreeLayout);

    layout->setSpacing(20);
}

/*!
    Initializes the page's fields based on values from fields on previous
    pages.
*/
void LicenseAgreementPage::entering()
{
    setComplete(true);
    setColoredTitle(tr("Welcome to LaCie RAID Manager"));

    if (packageManagerCore()->isInstaller()) {
        if (QAbstractButton *back = gui()->button(QWizard::BackButton))
            back->setVisible(false);
    }

    forceUpdateEnabled();

#if (defined Q_OS_WIN) || (defined Q_OS_OSX)
    if (packageManagerCore()->isInstaller()) {
        if (PackageManagerGui *w = gui()) {
            #ifdef Q_OS_WIN
            w->setOption(QWizard::IgnoreSubTitles, false);
            #elif defined Q_OS_OSX
            w->setOption(QWizard::IgnoreSubTitles, true);
            #endif

            // Update default actions
            w->button(QWizard::NextButton)->disconnect();
            connect(w->button(QWizard::NextButton), &QAbstractButton::clicked,
                    w, &QWizard::next);
        }
    }
#endif

    updateUi();
}

void LicenseAgreementPage::updateUi()
{
    m_msgLabel->setText(tr("Please review LaCie's policies before installing LaCie RAID Manager."));
    m_agreeLabel->setText(tr("I agree to LaCie's..."));

    auto a = tr("End User License Agreement");
    auto b = tr("Terms and Conditions");
    auto c = tr("Privacy Statement");

    m_eulaLabel->setText(QStringLiteral("<a href=\"https://www.lacie.com/legal-privacy/end-user-license-agreement/\">%1</a>").arg(a));
    m_termsAndConditionsLabel->setText(QStringLiteral("<a href=\"https://www.lacie.com/legal-privacy/terms-and-conditions/\">%1</a>").arg(b));
    m_privacyStatementLabel->setText(QStringLiteral("<a href=\"https://www.lacie.com/legal-privacy/privacy-policy/\">%1</a>").arg(c));
}

void LicenseAgreementPage::forceUpdateEnabled()
{
    if (packageManagerCore()->isInstaller()) {
        if (QAbstractButton *next = gui()->button(QWizard::NextButton))
        {
            next->setEnabled(m_eulaCheckBox->checkState() == Qt::Checked &&
                             m_termsAndConditionsCheckBox->checkState() == Qt::Checked &&
                             m_privacyStatementCheckBox->checkState() == Qt::Checked);
        }
    }
}
